type _Response = typeof globalThis extends { onmessage: any }
	? {}
	: import("undici-types").Response;

export interface Response extends _Response {}
export declare class Response {
	constructor(
		body?: Bun.BodyInit | null | undefined,
		init?: Bun.ResponseInit | undefined,
	);

	/**
	 * Create a new {@link Response} with a JSON body
	 *
	 * @param body - The body of the response
	 * @param options - options to pass to the response
	 *
	 * @example
	 *
	 * ```ts
	 * const response = Response.json({hi: "there"});
	 * console.assert(
	 *   await response.text(),
	 *   `{"hi":"there"}`
	 * );
	 * ```
	 * -------
	 *
	 * This is syntactic sugar for:
	 * ```js
	 *  new Response(JSON.stringify(body), {headers: { "Content-Type": "application/json" }})
	 * ```
	 * @link https://github.com/whatwg/fetch/issues/1389
	 */
	static json(body?: any, options?: Bun.ResponseInit | number): Response;
	/**
	 * Create a new {@link Response} that redirects to url
	 *
	 * @param url - the URL to redirect to
	 * @param status - the HTTP status code to use for the redirect
	 */
	// tslint:disable-next-line:unified-signatures
	static redirect(url: string, status?: number): Response;

	/**
	 * Create a new {@link Response} that redirects to url
	 *
	 * @param url - the URL to redirect to
	 * @param options - options to pass to the response
	 */
	// tslint:disable-next-line:unified-signatures
	static redirect(url: string, options?: Bun.ResponseInit): Response;

	/**
	 * Create a new {@link Response} that has a network error
	 */
	static error(): Response;
}
